var front = null;

/**
 * This class encapsules all functions for the front side of the widget.
 */
function Front() {
	this._init();
}

Front.prototype._init = function() {
    mouse_events = 'mouseover mouseout mousedown mouseup';
    buttons = Array(
        Array('#start', function() {
            front.stopAlarm();
            timer.run();
            front.toggleVisibility('#start', '#pause');
            front.toggleVisibility('#icon', '#rewind');
        }),
        Array('#pause', function() {
            timer.pause();
            front.toggleVisibility('#pause', '#start')
        }),
        Array('#rewind', function() {
            timer.rewind();
        }),
        Array('#stop', function() {
            front.stopAlarm();
        })
    );
    for (i in buttons) {
        // Remember to add "i = parseInt(i);" if you’re ever going to add some
        // calculations with "i"!! :-X
        
        button = buttons[i];
        $(button[0]).click(button[1]);
        $(button[0]).bind(mouse_events, {button: button[0]}, this.toggleButton);
    }

	fields = Array(
		'#timerTarget', 
		'#readyIn', 
		'#hours', 
		'#minutes', 
		'#seconds'
	);
	len = fields.length;
	for (var i in fields) {
        // If I don’t do parseInt(i), the expressions "(i + len - 1) % len" 
        // and "(i + 1) % len" won’t be evaluated each iteration, but be
        // cached instead. :-X
        i = parseInt(i);
        
	    field = fields[i];
	    input = field + 'Input';
        
	    $(field).bind('click', {editor: input}, this.showEdit);
		$(input).bind('blur keypress', {display: field}, this.setText);
		$(input).bind('keypress', {
		    pre: fields[(i + len - 1) % len], // i - 1 would not always be > 0!
		    next: fields[(i + 1) % len]}, this.cycleInputs);
		    
		if (i > 1)
			$(input).keypress(this.raiseOrLowerValue);
	}
};

/**
 * Stop the alarm.
 */
Front.prototype.stopAlarm = function() {
    timer.stopAlarm();
    front.toggleVisibility('#stop', '#icon');
};

/**
 * Hide one element and show the other.
 *
 * @param hide: Element to hide
 * @param show: Element to show
 */
Front.prototype.toggleVisibility = function(hide, show) {
    $(hide).css('visibility', 'hidden');
    $(show).css('visibility', 'visible');
};
	
/**
 * Handles the onMouseDown and onMouseUp events for buttons.
 *
 * @param event: The js event.
 */
Front.prototype.toggleButton = function(event) {
    pressed = (event.type == 'mouseover' || event.type == 'mousedown');
    filename = 'Images/' + event.data.button.slice(1);
    if (pressed)
        filename += '_clicked';
    filename += '.png';
    $(event.data.button).attr('src', filename);
};

/**
 * Show the stop alarm button.
 */
Front.prototype.showStopAlarmButton = function() {
    front.toggleVisibility('#icon', '#stop');
};

/**
 * Show the text input field to set an event or the time.
 *
 * @param event: The js event.
 */
Front.prototype.showEdit = function(event) {
    // Stop the timer if it is running
	if (timer.timerInterval)
		$('#pause').click();
		
	var display = $(event.target);
	var editor = $(event.data.editor);
	
	editor.attr('value', display.text());
	editor.css('visibility', 'visible');
	display.css('visiblity', 'hidden');
	editor.get(0).focus();
	
	if (display.attr('id') != 'readyIn')
		editor.get(0).select();
};

/**
 * Set the text from the input field to the display container and hide
 * the input field.
 *
 * @param event: The js event.
 */
Front.prototype.setText = function(event) {
	if (event.type == 'keypress' && event.keyCode != 13)
		return;
		
	var editor = $(event.target);
	var display = $(event.data.display);
	
	if (editor.css('visibility') == 'visible') {
		if (timer.timerInterval)
			clearInterval(timerInterval);
			
		if (editor.val().length < 1) {
			if (editor.attr('id') == 'timerTargetInput')
				editor.val(getLocalizedString('Something'));
			else
				editor.val('00');
		}
		
		if (display.attr('id') == 'timerTarget' || 
		        display.attr('id') == 'readyIn')
			display.text(editor.val());
		else {
		    var val = Math.min(Math.max(editor.val(), 0), 59);
		    display.text(front.formatTwoDigits(val));
		}
			
			
		if (display.attr('id') == 'timerTarget' && window.widget)
			setPrefForKey(editor.val(), widget.identifier, 'timerTarget');
		if (display.attr('id') == 'readyIn' && window.widget)
			setPrefForKey(editor.val(), widget.identifier, 'readyIn');
		if (display.attr('id') == 'hours' && window.widget)
			setPrefForKey(editor.val(), widget.identifier, 'hours');
		if (display.attr('id') == 'minutes' && window.widget)
			setPrefForKey(editor.val(), widget.identifier, 'minutes');
		if (display.attr('id') == 'seconds' && window.widget)
			setPrefForKey(editor.val(), widget.identifier, 'seconds');
			
		timer.isPaused = false; // Timer will read the inputs again.
			
		display.css('visibility', 'visible');
		editor.css('visibility', 'hidden');
	}
	// Start the timer if the user pressed enter.
	if (event.keyCode == 13)
		$('#start').click();
};

/**
 * Raise or lower the value in the hours, minutes or seconds field by one if
 * the user presses the up or down key.
 *
 * It seems like the dashboard uses other key codes for up/down as all all
 * other apps do. Weird???
 *
 * @param event: The js event.
 */
Front.prototype.raiseOrLowerValue = function(event) {
	if (event.keyCode != 38 && event.keyCode != 40
			&& event.keyCode != 63232 && event.keyCode != 63233)
		return;

	if (event.keyCode == 63232) event.keyCode = 38;
	if (event.keyCode == 63233) event.keyCode = 40;

	event.preventDefault();
	e = event.target;
	val = parseInt(e.value, 10);
	if (event.keyCode == 38 && val < 59)
		e.value = val + 1;
	else if (event.keyCode == 40 && val > 0)
		e.value = val -1;
};

/**
 * Cycles through the four input elements if the user presses tab or shift-tab.
 *
 * @param event: The js event.
 */
Front.prototype.cycleInputs = function(event) {
	if (event.keyCode != 9)
		return;
	event.preventDefault();
	if (event.shiftKey)
		$(event.data.pre).click();
	else
		$(event.data.next).click();
	$(event.target).blur();
};

/**
 * Update the timer display with the currently remaining time.
 */
Front.prototype.updateTimerDisplay = function() {
	$('#hours').text(front.formatTwoDigits(timer.remainingHours));
	$('#minutes').text(front.formatTwoDigits(timer.remainingMinutes));
	$('#seconds').text(front.formatTwoDigits(timer.remainingSeconds));
};

/**
 * Formats a number to to digits with leading zero.
 *
 * @param number: The number to format.
 * @return: The formatted number.
 */
Front.prototype.formatTwoDigits = function(number) {
	number = parseInt(number, 10);
	if (number < 0 || isNaN(number)) number = 0;

	number = number.toString(10);
	if (number.length == 1)
		number = '0' + number;
	return number;
};

/**
 * Resets the display to 00:00:00.
 */
Front.prototype.resetDisplay = function() {
	front.resetDisplayTo('00', '00', '00');
};

/**
 * Reset the display to the given time.
 */
Front.prototype.resetDisplayTo = function(hours, minutes, seconds) {
    front.toggleVisibility('#pause', '#start');
    front.toggleVisibility('#rewind', '#icon');
	$('#hours').text(hours);
	$('#minutes').text(minutes);
	$('#seconds').text(seconds);
};
